const express = require("express");
const axios = require("axios");
require("dotenv").config();

const app = express();
app.use(express.json());

// =========================
// CONFIG
// =========================
const SEND_MESSAGE_URL =
  "https://api.balesotomatis.id/public/v1/send_message_template";
  
const Send_pesan_test = 
    "https://api.balesotomatis.id/public/v1/send_meta_personal_message";

const CHECK_NUMBER_URL =
  "https://api.balesotomatis.id/public/v1/validate_number";

// =========================
// HEALTH CHECK
// =========================
app.get("/", (req, res) => {
  res.json({
    status: "API OK",
    service: "WA Proxy",
    time: new Date()
  });
});

// =========================
// KIRIM PESAN WA
// =========================
app.post("/v1/kirim-pesan", async (req, res) => {
  try {
    const { reciptient, message } = req.body;

    if (!reciptient || !message) {
      return res.status(400).json({
        success: false,
        message: "reciptient dan message wajib diisi"
      });
    }

    const payload = {
      secret_key: process.env.SECRET_KEY,
      licenses_key: process.env.LICENSES_KEY,
      recipients: reciptient,
      platform: "whatsapp_bisnis_api",
      method_send: "async",
      template:     "900826309365048",
      variables: [ String(message) ]
    };

    const response = await axios.post(SEND_MESSAGE_URL, payload, {
      headers: { "Content-Type": "application/json" },
      timeout: 15000
    });

    res.json({
      success: true,
      data: response.data
    });

  } catch (err) {
    res.status(500).json({
      success: false,
      message: "Gagal kirim pesan",
      error: err.response?.data || err.message
    });
  }
});

app.post("/v1/kirim-pesan/test", async (req, res) => {
  try {
    const { reciptient, message } = req.body;

    if (!reciptient || !message) {
      return res.status(400).json({
        success: false,
        message: "reciptient dan message wajib diisi"
      });
    }

    // const payload = {
    //   secret_key: process.env.SECRET_KEY,
    //   licenses_key: process.env.LICENSES_KEY,
    //   recipients: reciptient,
    //   platform: "whatsapp_bisnis_api",
    //   method_send: "async",
    //   template:     "1255953116377601",
    //   variables: [ String(message) ]
    // };
    
    const payload = {
        secret_key: "nVMpoZOU1a3150rWetk",
        licenses_key: "WB-tOD4McQ",
        reciptient: reciptient,
        platform: "whatsapp",
        method_send: "async",
        message: message,
    };
    

    const response = await axios.post(Send_pesan_test, payload, {
      headers: { "Content-Type": "application/json" },
      timeout: 15000
    });

    res.json({
      success: true,
      data: response.data
    });

  } catch (err) {
    res.status(500).json({
      success: false,
      message: "Gagal kirim pesan",
      error: err.response?.data || err.message
    });
  }
});

// =========================
// CEK NOMOR WA
// =========================
app.post("/v1/cek-nomor", async (req, res) => {
  try {
    const { phone_no, country_code } = req.body;

    if (!phone_no) {
      return res.status(400).json({
        success: false,
        message: "phone_no wajib diisi"
      });
    }

    const payload = {
      api_key: process.env.SECRET_KEY,
      number_id: "WB-Mjym4Ia",
      phone_no,
      country_code: country_code || "62"
    };

    const response = await axios.post(CHECK_NUMBER_URL, payload, {
      headers: { "Content-Type": "application/json" },
      timeout: 15000
    });

    res.json({
      success: true,
      data: response.data
    });

  } catch (err) {
    res.status(500).json({
      success: false,
      message: "Gagal cek nomor",
      error: err.response?.data || err.message
    });
  }
});

// =========================
// START SERVER
// =========================
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`🚀 API Proxy running on port ${PORT}`);
});
